const Joi = require('joi');

const validateRequest = (schema) => {
    return (req, res, next) => {
        const { error } = schema.validate(req.body, { allowUnknown: true });
        if (error) {
            return res.status(400).json({ message: error.details[0].message });
        }
        next();
    };
};

const schemas = {
    register: Joi.object({
        email: Joi.string().email().required(),
        password: Joi.string().min(6).required(),
        role: Joi.string().valid('Employer', 'Job Seeker').required(),
        fullName: Joi.string().optional(),
        companyName: Joi.string().optional()
    }),
    login: Joi.object({
        email: Joi.string().email().required(),
        password: Joi.string().required()
    }),
    employerProfile: Joi.object({
        companyName: Joi.string().required(),
        industry: Joi.string().required(),
        website: Joi.string().uri().required(),
        description: Joi.string().required(),
        logoUrl: Joi.string().optional().allow('')
    }),
    jobPost: Joi.object({
        title: Joi.string().required(),
        description: Joi.string().required(),
        location: Joi.string().required(),
        employmentType: Joi.string().valid('Full-time', 'Part-time', 'Contract', 'Internship').required(),
        salaryRange: Joi.string().optional().allow(''),
        requirements: Joi.string().optional().allow('')
    }),
    applicationStatus: Joi.object({
        // ADDED 'New' to the allowed values
        status: Joi.string().valid('New', 'Shortlisted', 'Interviewing', 'Hired', 'Rejected').required()
    })
};

module.exports = { validateRequest, schemas };