'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class Application extends Model {
    static associate(models) {
      this.belongsTo(models.Job, { foreignKey: 'jobId', as: 'job' });
      this.belongsTo(models.JobSeekerProfile, { foreignKey: 'jobSeekerProfileId', as: 'jobSeeker' });
    }
  }
  Application.init({
    jobId: DataTypes.INTEGER,
    jobSeekerProfileId: DataTypes.INTEGER,
    status: DataTypes.ENUM('New', 'Shortlisted', 'Interviewing', 'Hired', 'Rejected')
  }, {
    sequelize,
    modelName: 'Application',
  });
  return Application;
};