'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class Job extends Model {
    static associate(models) {
      this.belongsTo(models.EmployerProfile, { foreignKey: 'employerProfileId', as: 'employer' });
      this.hasMany(models.Application, { foreignKey: 'jobId', as: 'applications' });
      this.hasOne(models.Transaction, { foreignKey: 'jobId', as: 'transaction' });
    }
  }
  Job.init({
    employerProfileId: DataTypes.INTEGER,
    title: DataTypes.STRING,
    description: DataTypes.TEXT,
    location: DataTypes.STRING,
    salaryRange: DataTypes.STRING,
    requirements: DataTypes.TEXT,
    employmentType: {
      type: DataTypes.ENUM('Full-time', 'Part-time', 'Contract', 'Internship'),
      allowNull: false
    },
    status: {
      type: DataTypes.ENUM('Active', 'Filled', 'Closed'),
      defaultValue: 'Active',
      allowNull: false
    }
  }, {
    sequelize,
    modelName: 'Job',
  });
  return Job;
};