'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class Transaction extends Model {
    static associate(models) {
      this.belongsTo(models.EmployerProfile, { foreignKey: 'employerProfileId', as: 'employer' });
      this.belongsTo(models.Job, { foreignKey: 'jobId', as: 'job' });
    }
  }
  Transaction.init({
    employerProfileId: DataTypes.INTEGER,
    jobId: DataTypes.INTEGER,
    amount: DataTypes.DECIMAL,
    paymentGatewayRefId: DataTypes.STRING,
    status: DataTypes.ENUM('Pending', 'Completed', 'Failed')
  }, {
    sequelize,
    modelName: 'Transaction',
  });
  return Transaction;
};