const express = require('express');
const router = express.Router();
const { protect, hasRole } = require('../middleware/authMiddleware');
const { validateRequest, schemas } = require('../middleware/validationMiddleware');
const { 
    applyForJob, 
    getJobApplicants, 
    updateApplicationStatus, 
    getMyApplications, 
    sendApplicantEmail 
} = require('../controllers/applicationController');

// Job Seeker Routes
router.post('/job/:jobId', protect, hasRole('Job Seeker'), applyForJob);
router.get('/my-applications', protect, hasRole('Job Seeker'), getMyApplications); // New Route

// Employer Routes
router.get('/job/:jobId', protect, hasRole('Employer'), getJobApplicants);
router.put('/:applicationId/status', protect, hasRole('Employer'), validateRequest(schemas.applicationStatus), updateApplicationStatus);
router.post('/:applicationId/email', protect, hasRole('Employer'), sendApplicantEmail); // New Route for ATS Email

module.exports = router;