const express = require('express');
const router = express.Router();
const { protect, hasRole } = require('../middleware/authMiddleware');
const { uploadCV } = require('../middleware/uploadMiddleware');
const { validateRequest, schemas } = require('../middleware/validationMiddleware');
const { createEmployerProfile, createJobSeekerProfile, getMyProfile } = require('../controllers/profileController');

router.post('/employer', protect, hasRole('Employer'), validateRequest(schemas.employerProfile), createEmployerProfile);
router.post('/seeker', protect, hasRole('Job Seeker'), uploadCV.single('cv'), createJobSeekerProfile);
router.get('/me', protect, getMyProfile);

module.exports = router;